#include <windows.h>
#include <stdio.h>

#include "extern.h"



INT32 last8;
INT32 last4;



UINT8 DPCM4[] =
{
	0x00, 0x01, 0x02, 0x03,
	0x06, 0x0A, 0x0F, 0x15
};


INT16 DPCM8[] =
{
	// 0x00
	0x0000, 0x0008, 0x0010, 0x0020, 0x0030, 0x0040, 0x0050, 0x0060,
	0x0070, 0x0080,	0x0090, 0x00A0, 0x00B0, 0x00C0, 0x00D0, 0x00E0,

	// 0x10
	0x00F0, 0x0100, 0x0110, 0x0120,	0x0130, 0x0140, 0x0150, 0x0160,
	0x0170, 0x0180, 0x0190, 0x01A0, 0x01B0, 0x01C0,	0x01D0, 0x01E0,

	// 0x20
	0x01F0, 0x0200, 0x0208, 0x0210, 0x0218, 0x0220, 0x0228, 0x0230,
	0x0238, 0x0240, 0x0248, 0x0250, 0x0258, 0x0260, 0x0268, 0x0270,

	// 0x30
	0x0278, 0x0280,	0x0288, 0x0290, 0x0298, 0x02A0, 0x02A8, 0x02B0,
	0x02B8, 0x02C0, 0x02C8, 0x02D0,	0x02D8, 0x02E0, 0x02E8, 0x02F0,

	// 0x40
	0x02F8, 0x0300, 0x0308, 0x0310, 0x0318, 0x0320,	0x0328, 0x0330,
	0x0338, 0x0340, 0x0348, 0x0350, 0x0358, 0x0360, 0x0368, 0x0370,

	// 0x50
	0x0378, 0x0380, 0x0388, 0x0390, 0x0398, 0x03A0, 0x03A8, 0x03B0,
	0x03B8, 0x03C0,	0x03C8, 0x03D0, 0x03D8, 0x03E0, 0x03E8, 0x03F0,

	// 0x60
	0x03F8, 0x0400, 0x0440, 0x0480,	0x04C0, 0x0500, 0x0540, 0x0580,
	0x05C0, 0x0600, 0x0640, 0x0680, 0x06C0, 0x0700,	0x0740, 0x0780,

	// 0x70
	0x07C0, 0x0800, 0x0900, 0x0A00, 0x0B00, 0x0C00, 0x0D00, 0x0E00,
	0x0F00, 0x1000, 0x1400, 0x1800, 0x1C00, 0x2000, 0x3000, 0x4000
};



UINT8 RawDpcm4( INT index )
{
	if( index & 8 )
	{
		// subtract - v1, v2
		if( dpcm_ver == 1 )
			return DPCM4[ 15 - index ];

		else
			return DPCM4[ index & 7 ];
	}

	else
		return DPCM4[ index & 7 ];
}



INT16 RawDpcm8( INT index )
{
	return DPCM8[ index & 0x7F ];
}



INT16 Lookup8( INT index )
{
	if( index & 0x80 )
		return -DPCM8[ index & 0x7F ];

	else
		return DPCM8[ index & 0x7F ];
}



VOID Reset8( INT16 val )
{
	last8 = val;
}



UINT8 Index4( INT32 val )
{
	UINT8 ret;


	if( val < 0 )
	{
		ret = 0x08;
		val *= -1;
	}


	return ret;
}



UINT8 Index8( INT32 val )
{
	UINT8 ret;
	INT32 diff;


	// init
	ret = 0;


	// overflow
	if( val > 0x7fff || val < -0x8000 )
	{
		fprintf( fp_log, "OVER: %05X\n", val );


		fix_clip = FALSE;
		return last8;
	}

	
	
	// update curve
	diff = val - last8;
	last8 = val;



	// negative flag
	if( diff < 0 )
	{
		ret = 0x80;
		diff *= -1;
	}


	// find index
	for( int lcv = 0; lcv < 0x80; lcv++ )
	{
		if( diff == DPCM8[lcv] )
		{
			ret |= lcv;
			break;
		}
	}


	// missing entry
	if( lcv == 0x80 )
	{
		fprintf( fp_log, "MISS: %04X\n", diff & 0xFFFF );


		error_found++;
		fix_clip = FALSE;
	}


	return ret;
}



UINT8 Decode4( INT32 val, int index )
{
	overflow = FALSE;


	// Sierra DPCM table
	if( index & 8 )
	{
		if( dpcm_ver == 0 )
			val -= DPCM4[ 15 - index ];

		else
			val -= DPCM4[ index & 7 ];
	}

	else
		val += DPCM4[ index & 7 ];




	// overflow - adjust value
	if( val > 255 )
	{
		val -= 256;

		overflow = TRUE;
	}

	else if( val < 0 )
	{
		val += 256;

		overflow = TRUE;
	}


	return val;
}



INT16 Decode8( INT32 val, int index )
{
	overflow = FALSE;


	// Sierra DPCM table
	val += Lookup8(index);



	// overflow - adjust value
	if( val > 32767 )
	{
		val -= 65536;

		overflow = TRUE;
	}

	else if( val < -32768 )
	{
		val += 65536;

		overflow = TRUE;
	}



	return val;
}
